/*
	Collection of utils.
	(This is a static class)
*/

#include "Arduino.h"
#include "Utils.h"
#include "ArduinoJson.h"


Utils::Utils(int test){
}

const char* Utils::stringToCharPointer(String input){

	return input.c_str();

}


//Will return true if the currentHours and currentMinutes value falls within the start and end times defined.
bool Utils::enableIfWithinTimeRange(int currentHours, int currentMinutes, int startHour, int startMinute, int endHour, int endMinute){

	//Converting times to seconds.
	unsigned int currentTime = (currentHours * 3600) + (currentMinutes * 60);
	unsigned int startTime = (startHour * 3600) + (startMinute * 60);
	unsigned int endTime = (endHour * 3600) + (endMinute * 60);


	if( (currentTime >= startTime) && (currentTime < endTime) ){
		return true;
	}
	else{
		return false;
	}


}


//Turns a bool into a boolstring.
String Utils::bTs(bool input){

	if(input == true){
		return "true";
	}
	else{
		return "false";
	}

}


JsonDocument Utils::parseJSON(String input){

	DynamicJsonDocument doc(2048); //Allocating for a 2kb json response
	DeserializationError error = deserializeJson(doc, input);

	if (error) {
	  Serial.print(F("deserializeJson() failed: "));
	  Serial.println(error.c_str());
	  return doc;
	}

	return doc;

}


